/*
 * Decompiled with CFR 0.152.
 */
package moe.score.pishockzap;

import com.google.gson.Gson;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import lombok.NonNull;
import moe.score.pishockzap.PlayerHpWatcher;
import moe.score.pishockzap.compat.Translation;
import moe.score.pishockzap.config.PishockZapConfig;
import moe.score.pishockzap.config.ShockDistribution;
import moe.score.pishockzap.pishockapi.PiShockApi;
import moe.score.pishockzap.pishockapi.PiShockSerialApi;
import moe.score.pishockzap.pishockapi.PiShockWebApiV1;
import moe.score.pishockzap.pishockapi.WebHookApi;
import moe.score.pishockzap.shockcalculation.ZapController;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1309;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

public class PishockZapMod
implements ClientModInitializer {
    public static final String NAME = "PiShock-Zap";
    @Nullable
    private static PishockZapMod instance = null;
    private static final class_304 keyBinding = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.pishock-zap.toggle", class_3675.class_307.field_1668, 301, "key.category.pishock-zap"));
    private final Logger logger = Logger.getLogger("PiShock-Zap");
    private final Path configFile = FabricLoader.getInstance().getConfigDir().resolve("PiShock-Zap".toLowerCase() + ".json");
    private final PishockZapConfig config = new PishockZapConfig();
    private final PlayerHpWatcher playerHpWatcher = new PlayerHpWatcher();
    private final ExecutorService apiExecutor = Executors.newSingleThreadExecutor();
    private final ZapController zapController = new ZapController(new PiShockWebApiV1(this.config, this.apiExecutor), this.config);

    public void saveConfig() {
        HashMap<String, Object> configMap = new HashMap<String, Object>();
        this.config.copyToConfig(configMap);
        Gson gson = new Gson();
        try (BufferedWriter configWriter = Files.newBufferedWriter(this.configFile, new OpenOption[0]);){
            gson.toJson(configMap, (Appendable)configWriter);
        }
        catch (IOException e) {
            this.logger.warning("Failed to save config file, exception details follow");
            e.printStackTrace();
        }
        this.applyConfigChanges();
    }

    private void applyConfigChanges() {
        switch (this.config.getApiType()) {
            case WEB_V1: {
                if (this.zapController.getApi() instanceof PiShockWebApiV1) break;
                this.zapController.setApi(new PiShockWebApiV1(this.config, this.apiExecutor));
                break;
            }
            case SERIAL: {
                PiShockSerialApi piShockSerialApi;
                PiShockApi piShockApi = this.zapController.getApi();
                if (piShockApi instanceof PiShockSerialApi && Objects.equals((piShockSerialApi = (PiShockSerialApi)piShockApi).getPortName(), this.config.getSerialPort())) break;
                this.zapController.setApi(new PiShockSerialApi(this.config, this.apiExecutor, this.config.getSerialPort()));
                break;
            }
            case WEBHOOK: {
                if (this.zapController.getApi() instanceof WebHookApi) break;
                this.zapController.setApi(new WebHookApi(this.config, this.apiExecutor));
            }
        }
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            PlayerHp hpInfo = this.getPlayerHp(player);
            this.playerHpWatcher.updatePlayerHpBypassIgnore(hpInfo.hp());
        }
    }

    public void loadConfig() {
        Map configMap;
        if (!Files.exists(this.configFile, new LinkOption[0])) {
            this.logger.info("Config file not found, using default config");
            this.saveConfig();
            return;
        }
        Gson gson = new Gson();
        try {
            configMap = (Map)gson.fromJson((Reader)Files.newBufferedReader(this.configFile), Map.class);
        }
        catch (Exception e) {
            this.logger.warning("Failed to load config file, exception details follow");
            e.printStackTrace();
            return;
        }
        this.config.setFromConfig(configMap);
        this.applyConfigChanges();
    }

    public void onPlayerHpChange() {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null || player.method_7325() || player.method_7337()) {
            this.playerHpWatcher.resetPlayer();
            return;
        }
        PlayerHp hpInfo = this.getPlayerHp(player);
        float damage = this.playerHpWatcher.updatePlayerHpAndGetDamage((class_1309)player, hpInfo.hp());
        if (hpInfo.hp() == hpInfo.maxHealth() || hpInfo.maxHealth() <= 0.0f) {
            return;
        }
        if (damage > 0.0f) {
            boolean deathZap = hpInfo.hp() == 0.0f;
            ShockDistribution distribution = deathZap && this.config.isShockOnDeath() ? this.config.getShockDistributionDeath() : this.config.getShockDistribution();
            float damageEquivalent = this.config.isShockOnHealth() ? hpInfo.maxHealth() - hpInfo.hp() : damage;
            if ((damageEquivalent /= hpInfo.maxHealth()) > 1.0f) {
                this.logger.warning("Damage equivalent " + damageEquivalent + " exceeds 100% damage, capping");
                damageEquivalent = 1.0f;
            }
            this.logger.info("Death? " + deathZap + ", damage: " + damage + ", hp: " + hpInfo.hp() + ", damage equivalent: " + damageEquivalent);
            this.zapController.queueShock(distribution, deathZap, damageEquivalent);
        }
    }

    @NonNull
    private PlayerHp getPlayerHp(class_746 player) {
        float hp = player.method_6032();
        float maxHealth = player.method_6063();
        if (!this.config.isFractionalDamage()) {
            hp = (float)Math.ceil(hp);
            maxHealth = (float)Math.ceil(maxHealth);
        }
        hp = Math.max(0.0f, Math.min(hp, maxHealth));
        return new PlayerHp(hp, maxHealth);
    }

    public void onInitializeClient() {
        instance = this;
        this.loadConfig();
        this.zapController.start();
        this.registerToggleHotkey();
    }

    private void registerToggleHotkey() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            while (keyBinding.method_1436()) {
                this.config.setEnabled(!this.config.isEnabled());
                this.saveConfig();
                class_746 player = client.field_1724;
                if (player == null) continue;
                class_2583 color = class_2583.field_24360.method_36139(this.config.isEnabled() ? 65280 : 0xFF0000);
                String key = "message.pishock-zap.toggle." + (this.config.isEnabled() ? "on" : "off");
                player.method_7353((class_2561)Translation.of(key).method_27696(color), false);
            }
        });
    }

    @Nullable
    public static PishockZapMod getInstance() {
        return instance;
    }

    public PishockZapConfig getConfig() {
        return this.config;
    }

    private record PlayerHp(float hp, float maxHealth) {
    }
}

